# sum files --------------------------------------------------------------------------------------------------------
#This function will calculate the mean and SD of the data, essentially collapsing the data into summarises statistics

average_data <- function(Data, iteration, 
                         grouping = c("Area.brain", "TreatmentID", "norm.time", 
                                      "Time.period", "Event", "Direction")) {
  tryCatch({
    
    flog.debug(paste0("Averaging iteration: ", iteration), name = log.name)
    Data.avg  <- data.frame()
    
    Data.avg <- Data %>%
      group_by_at(grouping) %>%
      summarise(avg.z.score = mean(z.score), 
                sd.z.score = sd(z.score),
                N = n(),
                sem.z.score = sd.z.score/sqrt(N)) %>% 
      ungroup()
    
    Data.avg <- Data.avg %>% mutate(iter = iteration)
    
    return(Data.avg)
    
  }, error = function(e) {
    flog.error("ERROR!", name = log.name)
    flog.error(e, name = log.name)
    return(Data)
  })
}

# parse files --------------------------------------------------------------------------------------------------------
#This function will read RDS files with parsing

merge_permutation_files <- function(file.name, iteration, Data_original, output.folder, group.columns) {
  tryCatch({
    Data <- data.frame()
    
    flog.info("Loading data....", name = log.name)
    flog.info(file.name, name = log.name)
    
    Data <- read_rds(path = paste0(output.folder, file.name))
    
    Data.merge <- data.frame()
    
    flog.debug("Joining", name = log.name)
    Data.merge <- left_join(Data_original, Data, by = c(group.columns, "Unit", "Event", "Time.period", "norm.time"))
    
        
    flog.debug("Averaging", name = log.name)
    Data.average <- average_data(Data.merge, iteration)

    Direction <- Data.merge %>% select(-z.score, -norm.time, -Time.period) %>% 
      unique() %>% mutate(iteration = iteration)
    
    return(list(Time.data = Data.average, Direction.data = Direction))
    
  }, error = function(e) {
    flog.error("ERROR!", name = log.name)
    flog.error(e, name = log.name)
    return(Data)
  })
}

